/* Bit setzen */
#define sbit(var, bit) ((var) |= (1 << (bit)))

/* Bit lschen */
#define cbit(var, bit) ((var) &= (unsigned)~(1 << (bit)))

/* Bit togglen */
#define toggle_bit(var,bit) ((var) ^= (1 << (bit)))

/* Bit abfragen */
#define bit_is_set(var, bit) ((var) & (1 << (bit)))
#define bit_is_clear(var, bit) !bit_is_set(var, bit)

/* Byte definieren*/
#define uint8_t byte

/*#####################################################################*/

#define F_CPU 20000000UL

#include <avr/io.h> //IO-Zugriff: Braucht man immer
#include <avr/interrupt.h> // V-USB braucht interrupts
#include <avr/wdt.h> //Watchdog: Sollte immer aktiv sein.

#include "usbdrv.h" //Der USB-Treiber
#include "util/delay.h" //Wird spter fr Timing etc. bentigt


USB_PUBLIC uchar usbFunctionSetup(uchar data[8]) {
	return 0; // do nothing for now
}

int main() {
	uchar i;

	wdt_enable(WDTO_1S); // enable 1s watchdog timer

	usbInit();
	
	usbDeviceDisconnect(); // enforce re-enumeration
	for(i = 0; i<250; i++) { // wait 500 ms
		wdt_reset(); // keep the watchdog happy
		_delay_ms(2);
	}
	usbDeviceConnect();

	sei(); // Enable interrupts after re-enumeration

	while(1) {
		wdt_reset(); // keep the watchdog happy
		usbPoll();
	}

	return 0;
}